/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.cells;

import anon.tor.cells.CreatedCell;
import anon.tor.cells.DestroyCell;
import anon.tor.cells.PaddingCell;
import anon.tor.cells.RelayCell;

public abstract class Cell {
    public static final int CELL_SIZE = 512;
    public static final int CELL_PAYLOAD_SIZE = 509;
    private int m_circID = 0;
    private int m_command;
    protected byte[] m_payload;

    protected Cell(int n) {
        this.m_command = n;
        this.m_payload = new byte[509];
    }

    protected Cell(int n, int n2) {
        this(n);
        this.m_circID = n2;
    }

    protected Cell(int n, int n2, byte[] byArray) {
        this(n, n2);
        this.setPayload(byArray, 0);
    }

    protected Cell(int n, int n2, byte[] byArray, int n3) {
        this(n, n2);
        this.setPayload(byArray, n3);
    }

    public byte[] getCellData() {
        byte[] byArray = new byte[512];
        byArray[0] = (byte)(this.m_circID >> 8 & 0xFF);
        byArray[1] = (byte)(this.m_circID & 0xFF);
        byArray[2] = (byte)(this.m_command & 0xFF);
        System.arraycopy(this.m_payload, 0, byArray, 3, 509);
        return byArray;
    }

    public int getCommand() {
        return this.m_command;
    }

    public int getCircuitID() {
        return this.m_circID;
    }

    public byte[] getPayload() {
        return this.m_payload;
    }

    public void setPayload(byte[] byArray, int n) {
        int n2 = Math.min(509, byArray.length);
        System.arraycopy(byArray, n, this.m_payload, 0, n2);
    }

    public static Cell createCell(byte[] byArray) {
        if (byArray.length != 512) {
            return null;
        }
        Cell cell = null;
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        switch (n2) {
            case 2: {
                cell = new CreatedCell(n, byArray, 3);
                break;
            }
            case 3: {
                cell = new RelayCell(n, byArray, 3);
                break;
            }
            case 4: {
                cell = new DestroyCell(n, byArray, 3);
                break;
            }
            case 0: {
                cell = new PaddingCell(n, byArray, 3);
                break;
            }
            default: {
                cell = null;
            }
        }
        return cell;
    }
}

