/*
 * Decompiled with CFR 0.152.
 */
package platform;

import anon.util.RecursiveFileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import logging.LogHolder;
import logging.LogType;
import platform.AbstractOS;

public class WindowsOS
extends AbstractOS {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    static /* synthetic */ Class class$java$io$File;

    public WindowsOS() throws Exception {
        String string = System.getProperty("os.name", "").toLowerCase();
        if (string.indexOf("win") == -1) {
            throw new Exception("Operating system is not Windows");
        }
        if (string.indexOf("windows 9") > -1) {
            this.initEnv("command.com /c set");
        } else {
            this.initEnv("cmd.exe /c set");
        }
        LogHolder.log((int)7, (int)LogType.MISC, (String)"platform.WindowsOS instantiated.");
    }

    protected boolean openLink(String string) {
        try {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            return true;
        }
        catch (Exception exception) {
            LogHolder.log((int)3, (int)LogType.MISC, (String)("Cannot open '" + string + "' in Windows default program."), (Throwable)exception);
            return false;
        }
    }

    protected String getAsString(URL uRL) {
        String string = super.getAsString(uRL);
        if (new StringTokenizer(string).countTokens() > 1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public boolean isHelpAutoInstalled() {
        return true;
    }

    public String getDefaultHelpPath(String string) {
        String string2 = this.getAppdataDefaultDirectory(string);
        if (string2 == null) {
            string2 = super.getDefaultHelpPath(string);
        }
        return string2;
    }

    public String getConfigPath(String string) {
        String string2 = System.getProperty("java.vendor", "unknown");
        String string3 = "";
        if (string2.trim().toLowerCase().startsWith("microsoft")) {
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("CMD /C SET").getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null && !string4.startsWith("USERPROFILE")) {
                }
                if (string4 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "=");
                    stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken().trim();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 == null) {
                string3 = System.getProperty("user.dir");
            }
        } else {
            string3 = this.getAppdataDefaultDirectory(string);
            if (string3 == null) {
                string3 = System.getProperty("user.home");
            }
        }
        return string3 + File.separator;
    }

    public String getAppdataDefaultDirectory(String string) {
        return this.getEnvPath(string, "APPDATA");
    }

    public boolean copyAsRoot(File file, File file2, AbstractOS.AbstractRetryCopyProcess abstractRetryCopyProcess) {
        try {
            long l;
            byte[] byArray;
            Class<?> clazz = Class.forName("gui.JAPDll");
            Class[] classArray = new Class[]{class$java$io$File == null ? (class$java$io$File = WindowsOS.class$("java.io.File")) : class$java$io$File, class$java$io$File == null ? (class$java$io$File = WindowsOS.class$("java.io.File")) : class$java$io$File, Boolean.TYPE};
            Method method = clazz.getMethod("xcopy", classArray);
            Object[] objectArray = new Object[]{file, file2, Boolean.TRUE};
            File file3 = new File(file2.getPath() + File.separator + file.getName());
            long l2 = RecursiveFileTool.getFileSize((File)file);
            long l3 = file3.length();
            try {
                byArray = RecursiveFileTool.createMD5Digest((File)file3);
            }
            catch (Exception exception) {
                LogHolder.log((int)2, (int)LogType.MISC, (Throwable)exception);
                byArray = null;
            }
            boolean bl = (Boolean)method.invoke(null, objectArray);
            boolean bl2 = false;
            if (!bl) {
                if (abstractRetryCopyProcess != null && abstractRetryCopyProcess.checkRetry()) {
                    return this.copyAsRoot(file, file2, abstractRetryCopyProcess);
                }
                LogHolder.log((int)3, (int)LogType.MISC, (String)"Root copy failed!");
                return false;
            }
            if (abstractRetryCopyProcess == null || abstractRetryCopyProcess.getMaxProgressSteps() <= 0) {
                return true;
            }
            long l4 = l = (long)(-1 * abstractRetryCopyProcess.getMaxProgressSteps());
            while (abstractRetryCopyProcess.incrementProgress()) {
                try {
                    l4 = l4 > 0L || !RecursiveFileTool.equals((File)file3, (byte[])byArray, (long)l3) ? RecursiveFileTool.getFileSize((File)file3) : ++l4;
                    if (l4 == l2) {
                        if (RecursiveFileTool.equals((File)file3, (File)file, (boolean)true)) {
                            while (abstractRetryCopyProcess.incrementProgress()) {
                            }
                            return true;
                        }
                        LogHolder.log((int)3, (int)LogType.MISC, (String)"Root copy failed!");
                        bl2 = true;
                        break;
                    }
                    if ((abstractRetryCopyProcess.getCurrentStep() > 1 || abstractRetryCopyProcess.getMaxProgressSteps() == 1) && l4 <= l) {
                        LogHolder.log((int)3, (int)LogType.MISC, (String)"Root copy failed!");
                        bl2 = true;
                        break;
                    }
                    l = l4;
                }
                catch (SecurityException securityException) {
                    LogHolder.log((int)3, (int)LogType.MISC, (Throwable)securityException);
                    bl2 = true;
                    break;
                }
                Thread.sleep(abstractRetryCopyProcess.getProgressLoopWaitMilliseconds());
                Thread.yield();
            }
            if (RecursiveFileTool.equals((File)file3, (File)file, (boolean)true)) {
                return true;
            }
            if (bl2 && abstractRetryCopyProcess.checkRetry()) {
                abstractRetryCopyProcess.reset();
                return this.copyAsRoot(file, file2, abstractRetryCopyProcess);
            }
        }
        catch (Throwable throwable) {
            LogHolder.log((int)2, (int)LogType.MISC, (Throwable)throwable);
        }
        return false;
    }

    public String getTempPath() {
        String string = super.getTempPath();
        if (string == null) {
            string = this.getenv("TEMP");
        }
        if (string == null) {
            string = this.getenv("TMP");
        }
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private String getEnvPath(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Application name is null!");
        }
        String string3 = null;
        string3 = this.getenv(string2);
        if (string3 != null && string3.trim().length() > 0 && new File(string3).exists()) {
            File file = new File((string3 = string3 + File.separator + string) + File.separator);
            if (!file.exists() && !file.mkdir()) {
                LogHolder.log((int)3, (int)LogType.MISC, (String)("Could not create storage directory: " + string3));
                string3 = null;
            }
        } else {
            string3 = null;
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

