/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HttpHeaderElement;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.UncompressInputStream;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class ContentEncodingModule
implements HTTPClientModule,
GlobalConstants {
    ContentEncodingModule() {
    }

    /*
     * WARNING - void declaration
     */
    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        void var5_5;
        Vector pae;
        NVPair[] hdrs = req.getHeaders();
        int idx = Util.getIndex(hdrs, "Accept-Encoding");
        if (idx == -1) {
            idx = hdrs.length;
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pae = new Vector();
        } else {
            try {
                pae = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement((Vector)var5_5, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: " + nfe.getMessage());
            }
        }
        if (!var5_5.contains(new HttpHeaderElement("deflate"))) {
            var5_5.addElement(new HttpHeaderElement("deflate"));
        }
        if (!var5_5.contains(new HttpHeaderElement("gzip"))) {
            var5_5.addElement(new HttpHeaderElement("gzip"));
        }
        if (!var5_5.contains(new HttpHeaderElement("x-gzip"))) {
            var5_5.addElement(new HttpHeaderElement("x-gzip"));
        }
        if (!var5_5.contains(new HttpHeaderElement("compress"))) {
            var5_5.addElement(new HttpHeaderElement("compress"));
        }
        if (!var5_5.contains(new HttpHeaderElement("x-compress"))) {
            var5_5.addElement(new HttpHeaderElement("x-compress"));
        }
        hdrs[idx] = new NVPair("Accept-Encoding", Util.assembleHeader((Vector)var5_5));
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        Vector pce;
        String ce = resp.getHeader("Content-Encoding");
        if (ce == null || req.getMethod().equals("HEAD")) {
            return;
        }
        try {
            pce = Util.parseHeader(ce);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (pce.size() == 0) {
            return;
        }
        String encoding = ((HttpHeaderElement)pce.firstElement()).getName();
        if (encoding.equalsIgnoreCase("gzip") || encoding.equalsIgnoreCase("x-gzip")) {
            resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("deflate")) {
            resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("compress") || encoding.equalsIgnoreCase("x-compress")) {
            resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("identity")) {
            pce.removeElementAt(pce.size() - 1);
        }
        if (pce.size() > 0) {
            resp.setHeader("Content-Encoding", Util.assembleHeader(pce));
        } else {
            resp.deleteHeader("Content-Encoding");
        }
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

