/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.AttributeSet;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementEx;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends ParentNode
implements ElementEx {
    private String tag;
    private AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    protected void setTag(String string) {
        this.tag = string;
    }

    void setAttributes(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.attributes;
        if (attributeSet2 != null && attributeSet2.isReadonly()) {
            throw new DomEx(7);
        }
        if (attributeSet != null) {
            attributeSet.setNameScope(this);
        }
        this.attributes = attributeSet;
        if (attributeSet2 != null) {
            attributeSet2.setNameScope(null);
        }
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void setReadonly(boolean bl) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(bl);
    }

    public String getNamespace() {
        String string = this.getPrefix();
        if (string == null) {
            return this.getInheritedAttribute("xmlns");
        }
        if ("xml".equals(string) || "xmlns".equals(string)) {
            return null;
        }
        String string2 = this.getInheritedAttribute("xmlns:" + string);
        if (string2 == null) {
            throw new IllegalStateException(this.getMessage("EN-000", new Object[]{string}));
        }
        return string2;
    }

    public String getLocalName() {
        int n = this.tag.indexOf(58);
        if (n < 0) {
            return this.tag;
        }
        return this.tag.substring(n + 1);
    }

    public String getPrefix() {
        int n = this.tag.indexOf(58);
        return n < 0 ? null : this.tag.substring(0, n);
    }

    public void setPrefix(String string) {
        int n = this.tag.indexOf(58);
        if (string == null) {
            if (n < 0) {
                return;
            }
            this.tag = this.tag.substring(n + 1);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        if (n < 0) {
            stringBuffer.append(this.tag);
        } else {
            stringBuffer.append(this.tag.substring(n + 1));
        }
        this.tag = stringBuffer.toString();
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        if (this.tag == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        writer.write(tagStart, 0, 1);
        writer.write(this.tag);
        if (this.attributes != null) {
            this.attributes.writeXml(xmlWriteContext);
        }
        if (!this.hasChildNodes()) {
            writer.write(tagEnd, 0, 3);
        } else {
            writer.write(tagEnd, 2, 1);
            this.writeChildrenXml(xmlWriteContext);
            writer.write(tagStart, 0, 2);
            writer.write(this.tag);
            writer.write(tagEnd, 2, 1);
        }
    }

    public void setIdAttributeName(String string) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = string;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.tag;
    }

    public String getNodeName() {
        return this.tag;
    }

    public String getAttribute(String string) {
        return this.attributes == null ? "" : this.attributes.getValue(string);
    }

    public String getAttribute(String string, String string2) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNode(string, string2);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.attributes != null) {
            int n = 0;
            while (true) {
                String string3;
                AttributeNode attributeNode;
                if ((attributeNode = (AttributeNode)this.attributes.item(n)) == null) {
                    return null;
                }
                if (string2.equals(attributeNode.getName()) && (string3 = attributeNode.getNamespace()) != null && string3.equals(string)) {
                    return attributeNode;
                }
                ++n;
            }
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        AttributeNode attributeNode;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((attributeNode = (AttributeNode)this.attributes.getNamedItem(string)) != null) {
            attributeNode.setNodeValue(string2);
        } else {
            attributeNode = new AttributeNode(string, string2, true, null);
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(attributeNode);
        }
    }

    public void removeAttribute(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            throw new DomEx(8);
        }
        this.attributes.removeNamedItem(string);
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(string);
        }
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(attr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr2 = this.getAttributeNode(attr.getNodeName());
        if (attr2 == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr2.getNodeName());
        return attr2;
    }

    public void normalize() {
        Node node;
        boolean bl = false;
        boolean bl2 = false;
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while ((node = this.item(n)) != null) {
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).normalize();
                    break;
                }
                case 3: {
                    Node node2 = this.item(n + 1);
                    if (node2 == null || node2.getNodeType() != 3) {
                        if (!bl2) {
                            bl = "preserve".equals(this.getInheritedAttribute("xml:space"));
                            bl2 = true;
                        }
                        if (bl) break;
                        char[] cArray = ((TextNode)node).data;
                        if (cArray == null || cArray.length == 0) {
                            this.removeChild(node);
                            --n;
                            break;
                        }
                        int n2 = this.removeWhiteSpaces(cArray);
                        if (n2 == cArray.length) break;
                        char[] cArray2 = new char[n2];
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        ((TextNode)node).data = cArray2;
                        break;
                    }
                    ((TextNode)node).joinNextText();
                    --n;
                    break;
                }
            }
            ++n;
        }
    }

    public int removeWhiteSpaces(char[] cArray) {
        int n = 0;
        int n2 = 0;
        block0: while (n2 < cArray.length) {
            int n3;
            boolean bl = false;
            if ((n3 = cArray[n2++]) == 32 || n3 == 9 || n3 == 10 || n3 == 13) {
                n3 = 32;
                bl = true;
            }
            cArray[n++] = n3;
            if (!bl) continue;
            while (n2 < cArray.length) {
                n3 = cArray[n2];
                if (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13) continue block0;
                ++n2;
            }
        }
        return n;
    }

    public Node cloneNode(boolean bl) {
        try {
            ElementNode elementNode = (ElementNode)this.getOwnerDocument().createElement(this.tag);
            if (this.attributes != null) {
                elementNode.setAttributes(new AttributeSet(this.attributes, true));
            }
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    elementNode.appendChild(node.cloneNode(true));
                    ++n;
                }
            }
            return elementNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public void write(Writer writer) throws IOException {
        this.writeXml(new XmlWriteContext(writer));
    }
}

