/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.MixParameters;
import anon.client.crypto.DataChannelCipher;
import anon.client.crypto.IMixCipher;
import anon.util.Base64;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class LastMixCipher
implements IMixCipher {
    private boolean m_firstEncryptionPacket = true;
    private MixParameters m_mixParameters;
    private DataChannelCipher m_dataChannelCipher;
    private boolean m_bDebug = false;

    public LastMixCipher(MixParameters mixParameters, DataChannelCipher dataChannelCipher, boolean bl) {
        this.m_mixParameters = mixParameters;
        this.m_dataChannelCipher = dataChannelCipher;
        this.m_bDebug = bl;
    }

    public byte[] encrypt(byte[] byArray, int n, Vector vector) {
        int n2 = byArray[0] << 8 & 0x3F00 | byArray[1] & 0xFF;
        byte[] byArray2 = new byte[n2 + 3 + DataChannelCipher.getMACSize()];
        byte[] byArray3 = null;
        if (this.m_firstEncryptionPacket) {
            byArray3 = this.m_dataChannelCipher.getKeys();
            byArray3[0] = (byte)(byArray3[0] & 0x7F);
            this.m_dataChannelCipher.setEncryptionKeysAES(byArray3);
        }
        try {
            this.m_dataChannelCipher.encryptGCM1(byArray, 0, byArray2, 0, n2 + 3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.m_firstEncryptionPacket) {
            return byArray2;
        }
        byte[] byArray4 = new byte[Math.max(byArray2.length + byArray3.length + this.m_mixParameters.getMixCipher().getPaddingSize(), this.m_mixParameters.getMixCipher().getOutputBlockSize())];
        byte[] byArray5 = new byte[this.m_mixParameters.getMixCipher().getInputBlockSize()];
        int n3 = byArray5.length - byArray3.length;
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray5, byArray3.length, Math.min(n3, byArray2.length));
        this.m_mixParameters.getMixCipher().encrypt(byArray5, 0, byArray4, 0);
        if (byArray2.length - n3 > 0) {
            System.arraycopy(byArray2, n3, byArray4, this.m_mixParameters.getMixCipher().getOutputBlockSize(), byArray2.length - n3);
        }
        this.m_firstEncryptionPacket = false;
        return byArray4;
    }

    public boolean decrypt(byte[] byArray) {
        try {
            if (this.m_bDebug) {
                LogHolder.log(7, LogType.CRYPTO, "LastMixDecryption - AN.ON Debug Mode Received Packet data: " + Base64.encode(byArray, false));
            }
            this.m_dataChannelCipher.decryptGCM2(byArray, 0, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            LogHolder.log(4, LogType.CRYPTO, "Decryption of MixPacket with integrity check failed: " + exception.getMessage());
            return false;
        }
        return true;
    }

    public int getNextPacketEncryptionOverhead() {
        int n = DataChannelCipher.getMACSize();
        if (this.m_firstEncryptionPacket) {
            n += this.m_dataChannelCipher.getKeys().length + this.m_mixParameters.getMixCipher().getPaddingSize();
        }
        return n;
    }
}

